"""Stub package for the present‑act V2 engine.

This package collects helper functions used by the simplified simulation in
Simulation A.  The real implementation would house the full present‑act
algorithm, including lexicographic acceptance, boolean gates, primitive
binary tie kernels and a lattice walker.  For this approximation the
functions are minimal or stubs so that the code structure matches the
specification without incurring heavy computation.
"""

from .rng import RNG
from .meter import make_feature_sets
__all__ = ["RNG", "make_feature_sets"]